﻿Imports System.IO
Imports System.Text

Public Class DataLogForm

    Private mySettings As ProgramSettings

    Public Sub New(ByRef settings As ProgramSettings, ByVal fields As String())

        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.
        mySettings = settings
        DataFields = fields

        Dim buttonAdd As New Button
        buttonAdd.Text = "Add"
        buttonAdd.Size = New Size(40, 23)
        TextBoxSeparator.Text = mySettings.LogSeparator

        If mySettings.LogItems IsNot Nothing Then
            For Each item As String In mySettings.LogItems
                AddFlowItem(item)
            Next
        End If
    End Sub

    Public ReadOnly Property DoLogData() As Boolean
        Get
            Return doLogDataValue
        End Get
    End Property
    Private doLogDataValue As Boolean = False

    Public Property DataFields() As String()
        Get
            Return dataFieldsValue
        End Get
        Set(ByVal value As String())
            dataFieldsValue = value
        End Set
    End Property
    Private dataFieldsValue As String()

    Private Sub ButtonSelectFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSelectFile.Click
        Using sfd As New SaveFileDialog()
            sfd.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*"
            sfd.FilterIndex = 1
            sfd.RestoreDirectory = True
            sfd.FileName = "data.txt"
            sfd.InitialDirectory = Microsoft.VisualBasic.FileIO.SpecialDirectories.Desktop
            If sfd.ShowDialog() = DialogResult.OK Then
                mySettings.LogFilePath = sfd.FileName
                TextBoxLogFilePath.Text = sfd.FileName
                'If Directory.Exists(Path.GetDirectoryName(mySettings.LogFilePath)) Then
                '    ButtonStart.Text = "Stop log"
                'End If
            End If
        End Using
    End Sub

    Private Sub ButtonStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonStart.Click
        If ButtonStart.Text = "Start log" AndAlso File.Exists(mySettings.LogFilePath) Then
            If MessageBox.Show("Log file already exists. Overwrite?", "Overwrite?", MessageBoxButtons.OKCancel, MessageBoxIcon.Question) = Windows.Forms.DialogResult.Cancel Then
                Exit Sub
            End If
        End If

        If ButtonStart.Text = "Start log" Then
            ButtonStart.Text = "Stop log"
            doLogDataValue = True
        Else
            ButtonStart.Text = "Start log"
            doLogDataValue = False
        End If
    End Sub

    Private Sub ButtonAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonAdd.Click
        AddFlowItem()
    End Sub

    Private Sub ButtonDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonClear.Click
        DeleteFlowItem()
    End Sub

    Public Sub AddFlowItem()
        AddFlowItem(String.Empty)
    End Sub


    Public Sub AddFlowItem(ByVal item As String)
        ButtonClear.Visible = True
        If FlowLayoutPanel1.Controls.Count > 0 Then
            Dim t As New SeparatorControl()
            t.Text = TextBoxSeparator.Text
            t.Width = 20
            t.Height = 40
            t.BorderStyle = BorderStyle.None
            FlowLayoutPanel1.Controls.Add(t)
        End If

        Dim c As New ComboBox
        c.Items.AddRange(DataFields)
        AddHandler c.SelectedIndexChanged, AddressOf SaveItemsToSettings

        FlowLayoutPanel1.Controls.Add(c)

        If Not String.IsNullOrEmpty(item) AndAlso DataFields.Contains(item) Then c.SelectedItem = item
    End Sub

    Public Sub DeleteFlowItem()
        FlowLayoutPanel1.Controls.RemoveAt(FlowLayoutPanel1.Controls.Count - 1)
        If FlowLayoutPanel1.Controls.Count = 0 Then
            ButtonClear.Visible = False
        Else
            FlowLayoutPanel1.Controls.RemoveAt(FlowLayoutPanel1.Controls.Count - 1) ' Remove separator
        End If
    End Sub

    Private Sub TextBoxSeparator_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TextBoxSeparator.TextChanged
        mySettings.LogSeparator = TextBoxSeparator.Text
        For Each control As Object In FlowLayoutPanel1.Controls
            If TypeOf (control) Is SeparatorControl Then
                CType(control, SeparatorControl).Text = TextBoxSeparator.Text
            End If
        Next
    End Sub

    Public Function GetLogString(ByRef FOC As BoardVarStruct) As String
        Dim logStringbuilder As New StringBuilder
        For Each Control As Object In FlowLayoutPanel1.Controls
            If TypeOf (Control) Is ComboBox Then
                If CType(Control, ComboBox).SelectedIndex <> -1 Then
                    If Not String.IsNullOrEmpty(CType(Control, ComboBox).SelectedItem) Then
                        logStringbuilder.Append(FOC.GetType.GetField(CType(Control, ComboBox).SelectedItem).GetValue(FOC))
                        logStringbuilder.Append(Me.TextBoxSeparator.Text)
                    End If
                End If
            End If
        Next
        Return logStringbuilder.ToString
    End Function

    Private Class SeparatorControl
        Inherits UserControl

        Private labelText As New Label

        Public Sub New()
            labelText.Font = New Font(labelText.Font.FontFamily, 16, FontStyle.Regular, GraphicsUnit.Pixel)
            Me.Controls.Add(labelText)
        End Sub

        Public Overloads Property Text() As String
            Get
                Return labelText.Text
            End Get
            Set(ByVal value As String)
                labelText.Text = value
            End Set
        End Property
    End Class

    Private Sub SaveItemsToSettings()
        Dim itemsList As New List(Of String)
        For Each Control As Object In FlowLayoutPanel1.Controls
            If TypeOf (Control) Is ComboBox Then
                If CType(Control, ComboBox).SelectedIndex <> -1 Then
                    If Not String.IsNullOrEmpty(CType(Control, ComboBox).SelectedItem) Then
                        itemsList.Add(CType(Control, ComboBox).SelectedItem)
                    End If
                End If
            End If
        Next
        mySettings.LogItems = itemsList.ToArray
    End Sub

End Class